/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.util;

public class ColorHelper {
    public static int RGB(int r, int g, int b) {
        return ColorHelper.RGBA(r, g, b, 255);
    }

    public static int RGBA(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int RGB(float red, float green, float blue) {
        return ColorHelper.RGBA((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), 255);
    }

    public static int RGB(float red, float green, float blue, float alpha) {
        return ColorHelper.RGBA((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static int RGB(String colour) {
        if (!colour.startsWith("#") || colour.length() != 7) {
            throw new IllegalArgumentException("Use #RRGGBB format");
        }
        return ColorHelper.RGB(Integer.parseInt(colour.substring(1, 3), 16), Integer.parseInt(colour.substring(3, 5), 16), Integer.parseInt(colour.substring(5, 7), 16));
    }

    public static String asRGBString(int colour) {
        return "#" + Integer.toHexString(colour).toUpperCase().substring(2);
    }
}

